/*---------------------------------------------------------------*/

/* "hd:mpw:riigsincludes:typesiigs.r"   */
#include "typesiigs.r" 

/*------------------- Values used through out -------------------*/

#define CatalogWindow	$1000
#define StrikeWindow	$1001


/*----------------------- About Box ------------------------------*/
resource rAlertString (1) {
	"0\$19\$00\$A0\$00\$AA\$00\$E0\$01"
	"0/"
	TBCenterJust
	TBStyleOutline
	"Font Report"
	TBEndOfLine
	TBStylePlain
	"A sample program to demonstrate program calls to the Apple IIGS Font Manager."
	TBEndOfLine
	TBEndOfLine
	"by"
	TBEndOfLine
	"Dan Strnad"
	TBEndOfLine
	TBEndOfLine
	"Copyright Apple Computer, Inc."
	TBEndOfLine
	"All Rights Reserved"
	TBEndOfLine
	"Version 3.0/^#6\$00"
};




/*----------------------Startup Record ---------------------------*/
resource rToolStartup (1)	{
	mode640,							/* master SCB */
	{ 	
		3,$0300,	/* misc tools */
		4,$0301,	/* quickdraw */
		5,$0302,	/* desk manager */
		6,$0300,	/* eventMgr */
		7,$0200,	/* scheduler */
/*		8,$0301,	/* sound tools */
/*		9,$0201,	/* ADB tools */
		10,$0202,	/* SANE */
		11,$0200,	/* int math */
		12,$0201,	/* Text Tool Set */
		14,$0301,	/* Window Manager */
		15,$0301,	/* Menu Manager */
		16,$0301,	/* Control Manager */
		17,$0300,	/* System Loader */
		18,$0301,	/* QD Aux */
/*		19,$0300,	/* print manager */
		20,$0301,	/* LineEdit tool set */
		21,$0302,	/* Dialog Manager */
		22,$0300,	/* Scrap manager */
		23,$0301,	/* standard file */
/*		25,$0104,	/* NoteSynth */
/*		26,$0104,	/* Note Seq */
		27,$0301,	/* Font manager */
		28,$0301,	/* list manager */
/*		29,$0101,	/* ACE */
/*		32,$0103,	/* Midi Tools */
/*		34,$0101	/* text edit */
	}
};



/*---------------------------------------------------------------------------*/
/*
/* Font Catalog Window
/*
/* This is the template for the font catalog window
/*
/*---------------------------------------------------------------------------*/
resource rWindParam1 (CatalogWindow) {
	0xdda0,													/* Frame Bits 			*/
	0x201,													/* title ID   			*/
	0,														/* ref Con    			*/
	{0,0,0,0},												/* Zoom Rect  			*/
	0,														/* color table id 		*/
	{0,0},													/* origin 				*/
	{800,640},												/* data size 			*/
	{0,0},													/* max height-width		*/
	{4,16},													/* scroll amount, hor,ver */
	{40,160},												/* page amount */
	0,														/* wInfo Ref Con */
	0,														/* wInfo height */
	{25,20,170,500},										/* window Position */
	0xffffffff,												/* wPlane */
	Nil,													/* Control Ref */
	refIsResource*0x0100+resourceToResource 				/* descriptor */
};

/*---------------------------------------------------------------------------*/
/* This is the title of the font catalog window
/*---------------------------------------------------------------------------*/
resource rPString (0x201) {
	"Font Catalog"
	};



/*---------------------------------------------------------------------------*/
/*
/* Font Strike Window
/*
/* This is the template for the font strike window
/*
/*---------------------------------------------------------------------------*/
resource rWindParam1 (StrikeWindow) {
	0xdda0,													/* Frame Bits 			*/
	0x202,													/* title ID   			*/
	0,														/* ref Con    			*/
	{0,0,0,0},												/* Zoom Rect  			*/
	0,														/* color table id 		*/
	{0,0},													/* origin 				*/
	{800,640},												/* data size 			*/
	{0,0},													/* max height-width		*/
	{4,16},													/* scroll amount, hor,ver */
	{40,160},												/* page amount */
	0,														/* wInfo Ref Con */
	0,														/* wInfo height */
	{45,213,180,550},										/* window Position */
	0xffffffff,												/* wPlane */
	Nil,													/* Control Ref */
	refIsResource*0x0100+resourceToResource 				/* descriptor */
};


/*---------------------------------------------------------------------------*/
/* This is the title of the font strike window
/*---------------------------------------------------------------------------*/
resource rPString (0x202) {
	"Font Strike"
	};



/* *************************************************************************  */
/*
/* 			Menus
/*
/* This sample program uses menu items that start at 250. The Edit menu items */
/* if they were present would be entered first to conform to the menu manager */
/* documentation. The About and Quit menu items use IDs 256 and 257 as a      */
/* convention.					 											  */
/*																			  */
/* *************************************************************************  */

#define AppleMenuID			$1100
#define AboutID				$1101
#define FileMenuID			$1200
#define OpenCatWindowID		$1201
#define OpenStrikeWindowID	$1202
#define QuitID				257
#define FontMenuID			$1300
#define ChooseID			$1301



resource rMenuBar (1) {
	{
		AppleMenuID,
		FileMenuID,
		FontMenuID
	};
};

resource rMenu (AppleMenuID)	{
	AppleMenuID,
 	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
	AppleMenuID,
	{ AboutID };
};

resource rMenu (FileMenuID)	{
	FileMenuID,
 	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
	FileMenuID,
	{ OpenCatWindowID,
	OpenStrikeWindowID,
	QuitID };
};

resource rMenu (FontMenuID)	{
	FontMenuID,
 	RefIsResource*MenuTitleRefShift+RefIsResource*ItemRefShift+fAllowCache,
	FontMenuID,
	{ ChooseID };
};

resource rMenuItem (AboutID)	{
	AboutID,
	"","",
	0,
 	RefIsResource*ItemTitleRefShift+fDivider,
	AboutID
};

resource rMenuItem (OpenCatWindowID)	{
	OpenCatWindowID,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fDisabled,
	OpenCatWindowID
};

resource rMenuItem (OpenStrikeWindowID)	{
	OpenStrikeWindowID,
	"","",
	0,
	RefIsResource*ItemTitleRefShift+fDisabled,
	OpenStrikeWindowID
};

resource rMenuItem (QuitID)	{
	QuitID,
	"Q","q",
	0,
 	RefIsResource*ItemTitleRefShift,
	QuitID
};

resource rMenuItem (ChooseID)	{
	ChooseID,
	"C","c",
	0,
 	RefIsResource*ItemTitleRefShift,
	ChooseID
};


resource rPString (AppleMenuID) {
	"@"
	};
resource rPString (FileMenuID) {
	"  File  "
	};
resource rPString (FontMenuID) {
	"  Font  "
	};
resource rPString (AboutID) {
	"About Font Report..."
	};
resource rPString (OpenCatWindowID) {
	"Open Font Catalog Window"
	};
resource rPString (OpenStrikeWindowID) {
	"Open Font Strike Window"
	};
resource rPString (QuitID) {
	"Quit"
	};
resource rPString (ChooseID) {
	"Choose..."
	};




